/*
 * Decompiled with CFR 0.152.
 */
package com.bw.hakuna;

import com.bw.hakuna.console.HakunaConsole;
import com.bw.hakuna.console.LokativConsole;
import com.bw.hakuna.console.NegationConsole;
import com.bw.hakuna.console.NumbersConsole;
import com.bw.hakuna.console.ObjectinfixConsole;
import com.bw.hakuna.console.PossessiveConsole;
import com.bw.hakuna.console.QuestionsConsole;
import com.bw.hakuna.console.TimeConsole;
import com.bw.hakuna.console.VocabularyConsole;
import com.bw.hakuna.gui.HakunaGUI;
import com.bw.hakuna.gui.LokativGUI;
import com.bw.hakuna.gui.NegationGUI;
import com.bw.hakuna.gui.NumbersGUI;
import com.bw.hakuna.gui.ObjectinfixGUI;
import com.bw.hakuna.gui.PossessiveGUI;
import com.bw.hakuna.gui.QuestionsGUI;
import com.bw.hakuna.gui.TimeGUI;
import com.bw.hakuna.gui.VocabularyGUI;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class Hakuna {
    private static HakunaConsole[] areas = new HakunaConsole[]{new NegationConsole(), new NumbersConsole(), new TimeConsole(), new PossessiveConsole(), new QuestionsConsole(), new VocabularyConsole(), new LokativConsole(), new ObjectinfixConsole()};
    private static final String me = "hakuna";

    private static String[] shift(String[] stringArray, int n) {
        String[] stringArray2;
        assert (n >= 0 && n <= stringArray.length);
        if (stringArray.length > n) {
            stringArray2 = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, stringArray2, 0, stringArray.length - n);
        } else {
            stringArray2 = new String[]{};
        }
        return stringArray2;
    }

    public static void help() {
        System.out.printf("Usage: %s [OPTION]... AREA [OPTION]...\n", me);
        System.out.println("Practice Swahili grammar.");
        System.out.println();
        System.out.println("      --console         console mode (default on non Windows)");
        System.out.println("      --gui             GUI mode (default on Windows)");
        System.out.println();
        System.out.println("Areas:");
        for (HakunaConsole hakunaConsole : areas) {
            System.out.printf("  %s\n", hakunaConsole.getArea());
        }
        System.out.println();
    }

    private static void addTab(JTabbedPane jTabbedPane, String string, HakunaGUI hakunaGUI) {
        jTabbedPane.addTab(hakunaGUI.getLabel(string), hakunaGUI);
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("Hakuna");
        jFrame.setDefaultCloseOperation(3);
        JTabbedPane jTabbedPane = new JTabbedPane();
        String string = Locale.getDefault().getLanguage();
        Hakuna.addTab(jTabbedPane, string, new NegationGUI());
        Hakuna.addTab(jTabbedPane, string, new NumbersGUI());
        Hakuna.addTab(jTabbedPane, string, new TimeGUI());
        Hakuna.addTab(jTabbedPane, string, new PossessiveGUI());
        Hakuna.addTab(jTabbedPane, string, new QuestionsGUI());
        Hakuna.addTab(jTabbedPane, string, new VocabularyGUI());
        Hakuna.addTab(jTabbedPane, string, new LokativGUI());
        Hakuna.addTab(jTabbedPane, string, new ObjectinfixGUI());
        jFrame.getContentPane().add(jTabbedPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        int n;
        boolean bl = System.getProperty("os.name").contains("Windows");
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].contentEquals("--console")) {
                bl = false;
                continue;
            }
            if (stringArray[n].contentEquals("--gui")) {
                bl = true;
                continue;
            }
            if (stringArray[n].contentEquals("--help")) {
                Hakuna.help();
                System.exit(0);
                continue;
            }
            if (stringArray[n].contentEquals("--version")) {
                System.out.printf("%s 0.28/Java\n", me);
                System.exit(0);
                continue;
            }
            if (stringArray[n].startsWith("--")) {
                System.err.printf("%s: invalid option -- '%s'\n", me, stringArray[n]);
                System.err.printf("Try `%s --help' for more information.\n", me);
                System.exit(1);
                continue;
            }
            if (!stringArray[n].startsWith("-")) break;
            System.err.printf("%s: unrecognized option '%s'\n", me, stringArray[n].replaceFirst("-", ""));
            System.err.printf("Try `%s --help' for more information.\n", me);
            System.exit(1);
        }
        HakunaConsole hakunaConsole = null;
        if (n < stringArray.length) {
            for (HakunaConsole hakunaConsole2 : areas) {
                if (!hakunaConsole2.getArea().contentEquals(stringArray[n])) continue;
                hakunaConsole = hakunaConsole2;
                break;
            }
            if (hakunaConsole == null) {
                System.err.printf("%s: invalid area -- '%s'\n", me, stringArray[n]);
                System.err.printf("Try `%s --help' for more information.\n", me);
                System.exit(1);
            } else {
                ++n;
            }
        }
        if (bl) {
            if (n < stringArray.length) {
                System.err.printf("%s: extra operand '%s'\n", me, stringArray[n]);
                System.err.printf("Try `%s --help' for more information.\n", me);
                System.exit(1);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Hakuna.createAndShowGUI();
                }
            });
        } else {
            if (hakunaConsole == null) {
                Hakuna.help();
                System.exit(0);
            }
            System.exit(hakunaConsole.main(me, Hakuna.shift(stringArray, n)));
        }
    }
}

