/*
 * Decompiled with CFR 0.152.
 */
package com.bw.hakuna.console;

import com.bw.swahili.SimpleTask;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public abstract class HakunaConsole {
    public static final int OPT_EFFECT_LENGTH = 53;
    private static final String[][] YN = new String[][]{{"y", "yes"}, {"q", "quit"}, {"s", "stat"}, {"yq", "qy"}, {"nq", "qn"}, {"?"}};
    protected boolean CHEATSHEET = false;
    protected int DELAY = 0;
    protected boolean LIST = false;
    protected boolean STATISTICS = false;
    protected boolean TRANSLATE = false;
    protected boolean ANSI = true;
    protected String me = this.getClass().getName();
    private String area;
    protected SimpleTask st;

    public abstract String versionNr();

    public abstract String helpDescription();

    public String getInfo() {
        return this.st.getInfo();
    }

    public String getTask() {
        return this.st.getTask();
    }

    public String getSolution() {
        return this.st.getSolution();
    }

    public void cheatsheet() {
    }

    public void printStatistics() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.st.getK() > 0) {
            d = 100.0 * (double)this.st.getY() / (double)this.st.getK();
            d2 = 100.0 * (double)this.st.getN() / (double)this.st.getK();
        }
        System.out.println();
        System.out.printf("%d of %d right (%.2f%%), %d of %d wrong (%.2f%%).\n", this.st.getY(), this.st.getK(), d, this.st.getN(), this.st.getK(), d2);
        System.out.println();
        this.cheatsheet();
    }

    private int keyIndex(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].contentEquals(string)) continue;
            return i;
        }
        return -1;
    }

    protected boolean enableDisable(String string, EnablerDisabler enablerDisabler2, String string2, String[] stringArray) {
        int n = -1;
        do {
            String string3;
            int n2;
            if ((n = string.indexOf(44, n2 = n + 1)) == -1) {
                n = string.length();
            }
            if (this.keyIndex(string3 = string.substring(n2, n), stringArray) < 0) {
                System.out.printf("%s: unknown %s '%s'\n", this.me, string2, string3);
                return false;
            }
            boolean bl = enablerDisabler2.set(this.st, string3);
            assert (bl);
        } while (n < string.length());
        return true;
    }

    protected void printOptions() {
        this.printOption("-d", "--delay=N", "delay (if not collecting statistics)");
        this.printOption("-l", "--list", "don't clear screen per word");
        this.printOption("", "--norepetition", "don't re-ask recently wrong tasks");
        this.printOption("", "", "(only effective with statistics)");
        this.printOption("-s", "--statistics", "collect statistics");
        this.printOption("-t", "--translate", "show translation on top (if available)");
        this.printOption("-x", "--cheatsheet", "show cheatsheet on top (if available)");
    }

    protected int getopt(String[] stringArray, int n) {
        int n2 = 1;
        if (stringArray[n].contentEquals("-d") || stringArray[n].contentEquals("--delay")) {
            if (n == stringArray.length - 1) {
                this.DELAY = 0;
            } else {
                try {
                    this.DELAY = Integer.parseInt(stringArray[n + n2++]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.DELAY = 0;
                }
            }
        } else if (stringArray[n].startsWith("--delay=")) {
            try {
                this.DELAY = Integer.parseInt(stringArray[n].replaceFirst("--delay=", ""));
            }
            catch (NumberFormatException numberFormatException) {
                this.DELAY = 0;
            }
        } else if (stringArray[n].contentEquals("-l") || stringArray[n].contentEquals("--list")) {
            this.LIST = true;
        } else if (stringArray[n].contentEquals("--norepetition")) {
            this.st.setRepetition(false);
        } else if (stringArray[n].contentEquals("-s") || stringArray[n].contentEquals("--statistics")) {
            this.STATISTICS = true;
        } else if (stringArray[n].contentEquals("-t") || stringArray[n].contentEquals("--translate")) {
            this.TRANSLATE = true;
        } else if (stringArray[n].contentEquals("-x") || stringArray[n].contentEquals("--cheatsheet")) {
            this.CHEATSHEET = true;
        } else if (stringArray[n].contentEquals("--help")) {
            this.printHelp();
            n2 = -1;
        } else if (stringArray[n].contentEquals("--version")) {
            System.out.printf("%s %s\n", this.area, this.versionNr());
            n2 = -1;
        } else if (stringArray[n].startsWith("--")) {
            System.err.printf("%s: invalid option -- '%s'\n", this.me, stringArray[n]);
            System.err.printf("Try `%s --help' for more information.\n", this.me);
            n2 = 0;
        } else {
            System.err.printf("%s: unrecognized option '%s'\n", this.me, stringArray[n].replaceFirst("-", ""));
            System.err.printf("Try `%s --help' for more information.\n", this.me);
            n2 = 0;
        }
        return n2;
    }

    protected int getopt(String[] stringArray) {
        int n;
        for (int i = 0; i < stringArray.length; i += n) {
            n = this.getopt(stringArray, i);
            if (n > 0) continue;
            return n;
        }
        return 1;
    }

    protected void printKeys(String string, String[] stringArray, String string2) {
        String string3 = "";
        for (String string4 : stringArray) {
            String string5 = "'" + string4 + "'";
            if ((string + string3 + string5).length() < 53 - string2.length()) {
                string = string + string3 + string5;
                string3 = ", ";
                continue;
            }
            this.printOption("", "", string + ",");
            string = string5;
        }
        this.printOption("", "", string + string2);
    }

    protected final void printOption(String string, String string2, String string3) {
        String string4 = string.contentEquals("") || string2.contentEquals("") ? "" : ",";
        System.out.printf("  %2s%1s %-20s %-53s\n", string, string4, string2, string3);
    }

    private final void printHelp() {
        System.out.printf("Usage: %s [...] %s [OPTION]...\n", this.me, this.area);
        System.out.println(this.helpDescription());
        System.out.println();
        this.printOptions();
        this.printOption("", "--help", "display this help and exit");
        this.printOption("", "--version", "output version information and exit");
        System.out.println();
    }

    public final void clear() {
        if (this.LIST) {
            return;
        }
        if (this.ANSI) {
            System.out.print("\u001b[2J\u001b[;H");
            System.out.flush();
        }
    }

    private final int lookupYN(String string) {
        int n;
        for (n = 0; n < YN.length; ++n) {
            for (String string2 : YN[n]) {
                if (!string.contentEquals(string2)) continue;
                return n;
            }
        }
        return n;
    }

    public final int quit() {
        if (this.STATISTICS) {
            this.printStatistics();
        }
        return 0;
    }

    private final String readLine_or_exit(BufferedReader bufferedReader) {
        String string = null;
        try {
            string = bufferedReader.readLine();
        }
        catch (EOFException eOFException) {
            System.exit(0);
        }
        catch (IOException iOException) {
            if (iOException.getCause() != null) {
                System.err.println(iOException.getMessage());
            }
            System.exit(1);
        }
        if (string == null) {
            System.exit(0);
        }
        return string;
    }

    public final int main(String string, String[] stringArray) {
        this.me = string;
        int n = this.getopt(stringArray);
        if (n <= 0) {
            return n + 1;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block10: while (true) {
            this.st.shuffle();
            this.clear();
            if (this.CHEATSHEET) {
                this.cheatsheet();
            }
            if (this.TRANSLATE) {
                System.out.printf("( %s )\n", this.getInfo());
            }
            System.out.printf("%s", this.getTask());
            if (this.DELAY == 0) {
                this.readLine_or_exit(bufferedReader);
            } else {
                System.out.println();
                try {
                    TimeUnit.SECONDS.sleep(this.DELAY);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.printf("%s\n", this.getSolution());
            if (this.STATISTICS) {
                String string2 = "";
                block11: while (true) {
                    if (!string2.isEmpty()) continue block10;
                    System.out.printf("(y/N/s/[yn]q/?): ", new Object[0]);
                    string2 = this.readLine_or_exit(bufferedReader).toLowerCase();
                    switch (this.lookupYN(string2)) {
                        case 0: {
                            this.st.right();
                            continue block11;
                        }
                        case 1: {
                            return this.quit();
                        }
                        case 2: {
                            this.printStatistics();
                            string2 = "";
                            continue block11;
                        }
                        case 3: {
                            this.st.right();
                            return this.quit();
                        }
                        case 4: {
                            this.st.wrong();
                            return this.quit();
                        }
                        case 5: {
                            System.out.println("y|Y|yes|Yes|YES    -> yes (right answer)");
                            System.out.println("q|Q|quit|Quit|QUIT -> quit training");
                            System.out.println("yq|YQ              -> yes and quit");
                            System.out.println("nq|NQ              -> no and quit");
                            System.out.println("s|S|stat|Stat|STAT -> print current statistics");
                            System.out.println("?                  -> help");
                            System.out.println("<other>            -> no (wrong answer)");
                            string2 = "";
                            continue block11;
                        }
                    }
                    this.st.wrong();
                    string2 = "n";
                }
            }
            this.readLine_or_exit(bufferedReader);
        }
    }

    public final String getArea() {
        return this.area;
    }

    public HakunaConsole(SimpleTask simpleTask) {
        String string = simpleTask.getClass().getName();
        this.area = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
        this.st = simpleTask;
        if (System.getProperty("os.name").contains("Windows")) {
            this.ANSI = false;
            this.LIST = true;
        }
    }

    protected static interface EnablerDisabler {
        public boolean set(SimpleTask var1, String var2);
    }
}

