/*
 * Decompiled with CFR 0.152.
 */
package com.bw.hakuna.console;

import com.bw.hakuna.console.HakunaConsole;
import com.bw.swahili.Questions;
import com.bw.swahili.Qword;
import com.bw.swahili.SimpleTask;

public class QuestionsConsole
extends HakunaConsole {
    private boolean COLOUR = false;
    private static final String ASKCOLON = "\u001b[31m";
    private static final String ASKCOLOFF = "\u001b[0m";

    @Override
    public String versionNr() {
        return "0.01/Java";
    }

    @Override
    public String helpDescription() {
        return "Practice swahili questions.";
    }

    @Override
    public String getTask() {
        String string = this.st.getTask();
        if (this.COLOUR) {
            string = string.replaceFirst("_", ASKCOLON).replaceFirst("_", ASKCOLOFF);
        }
        return string;
    }

    @Override
    public void cheatsheet() {
        Questions questions = (Questions)this.st;
        System.out.println("+------------+-------------------+  +-----------+-------------------+");
        int n = 0;
        int n2 = 7;
        while (n < 6) {
            System.out.printf("| %10s | %-17s |  | %9s | %-17s |\n", Qword.qwords[n], questions.qcheat[n], Qword.qwords[n2], questions.qcheat[n2]);
            ++n;
            ++n2;
        }
        System.out.printf("| %10s | %-17s |  +-----------+-------------------+\n", Qword.qwords[n], questions.qcheat[n]);
        System.out.println("+------------+-------------------+");
        System.out.println();
    }

    @Override
    public void printStatistics() {
        super.printStatistics();
        int n = 0;
        System.out.printf("| %s | %s | %s  | %s | %s | %s | %s |\n", this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++]);
        System.out.println("+------+---------+------+------+------+------------+------+");
        int n2 = 0;
        System.out.printf("| %4d |   %4d  | %4d | %4d | %4d |     %4d   | %4d |\n", this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++]);
        System.out.println();
        System.out.printf("| %s | %s | %s | %s | %s | %s |\n", this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++]);
        System.out.println("+----------+------+------+-----------+--------+----------+");
        System.out.printf("|   %4d   | %4d | %4d |    %4d   |  %4d  |   %4d   |\n", this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++], this.st.getWrongtable()[0][n2++]);
        System.out.println();
    }

    @Override
    protected void printOptions() {
        super.printOptions();
        this.printOption("", "", "");
        this.printOption("-c", "--colour", "colour part to ask for");
        this.printOption("", "--dump", "dump all tasks (use as last option in order to make");
        this.printOption("", "", "previous -Q etc. to be effective)");
        this.printOption("-Q", "--questions=Q[,Q]", "enable given questions (comma separated list of");
        this.printKeys("questions (", Questions.question_keys, "))");
        this.printOption("", "--notquestions=N[,N]", "disable given questions");
        this.printOption("", "", "");
    }

    private boolean enableDisableQuestions(String string, HakunaConsole.EnablerDisabler enablerDisabler2) {
        return this.enableDisable(string, enablerDisabler2, "question", Questions.question_keys);
    }

    private boolean enableQuestions(String string) {
        return this.enableDisableQuestions(string, new HakunaConsole.EnablerDisabler(){

            @Override
            public boolean set(SimpleTask simpleTask, String string) {
                return ((Questions)simpleTask).enableQuestion(string);
            }
        });
    }

    private boolean disableQuestions(String string) {
        return this.enableDisableQuestions(string, new HakunaConsole.EnablerDisabler(){

            @Override
            public boolean set(SimpleTask simpleTask, String string) {
                return ((Questions)simpleTask).disableQuestion(string);
            }
        });
    }

    @Override
    protected int getopt(String[] stringArray, int n) {
        int n2 = 1;
        if (stringArray[n].contentEquals("-c") || stringArray[n].contentEquals("--color") || stringArray[n].contentEquals("--colour")) {
            this.COLOUR = true;
        } else if (stringArray[n].contentEquals("--dump")) {
            ((Questions)this.st).dump();
            n2 = -1;
        } else if (stringArray[n].contentEquals("-Q") || stringArray[n].contentEquals("--questions")) {
            if (n < stringArray.length - 1 && !this.enableQuestions(stringArray[n + n2++])) {
                n2 = 0;
            }
        } else if (stringArray[n].startsWith("--questions=")) {
            if (!this.enableQuestions(stringArray[n].replaceFirst("--questions=", ""))) {
                n2 = 0;
            }
        } else if (stringArray[n].contentEquals("--notquestions")) {
            if (n < stringArray.length - 1 && !this.disableQuestions(stringArray[n + n2++])) {
                n2 = 0;
            }
        } else if (stringArray[n].startsWith("--notquestions=")) {
            if (!this.disableQuestions(stringArray[n].replaceFirst("--notquestions=", ""))) {
                n2 = 0;
            }
        } else {
            n2 = super.getopt(stringArray, n);
        }
        return n2;
    }

    public QuestionsConsole() {
        super(new Questions());
    }
}

