/*
 * Decompiled with CFR 0.152.
 */
package com.bw.hakuna.console;

import com.bw.hakuna.console.HakunaConsole;
import com.bw.swahili.SimpleTask;
import com.bw.swahili.Time;

public class TimeConsole
extends HakunaConsole {
    @Override
    public String versionNr() {
        return "0.01/Java";
    }

    @Override
    public String helpDescription() {
        return "Practice swahili time.";
    }

    @Override
    public void printStatistics() {
        super.printStatistics();
        int n = 0;
        System.out.printf("|  %5s  | %7s | %7s | %7s || %5s | %3s | %3s | %3s | %5s |", this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++], this.st.Xrange()[n++]);
        System.out.println("\n+---------+---------+---------+---------++-------+-----+-----+-----+--------+");
        n = 0;
        System.out.printf("| %7d | %7s | %7s | %7s || %5d | %3d | %3d | %3d | %6d |", this.st.getWrongtable()[0][n++], this.st.getWrongtable()[0][n++], this.st.getWrongtable()[0][n++], this.st.getWrongtable()[0][n++], this.st.getWrongtable()[0][n++], this.st.getWrongtable()[0][n++], this.st.getWrongtable()[0][n++], this.st.getWrongtable()[0][n++], this.st.getWrongtable()[0][n++]);
        System.out.println();
        System.out.println();
    }

    @Override
    protected void printOptions() {
        super.printOptions();
        this.printOption("", "", "");
        assert (Time.time_category_keys.length == 3);
        this.printOption("-T", "--times=T[,T]", "enable given times (comma separated list of time");
        this.printOption("", "", "categories ('" + Time.time_category_keys[0] + "', '" + Time.time_category_keys[1] + "', '" + Time.time_category_keys[2] + "'))");
        this.printOption("", "--nottimes=T[,T]", "disable given time categories");
        this.printOption("", "", "");
    }

    private boolean enableDisableTimeCategories(String string, HakunaConsole.EnablerDisabler enablerDisabler2) {
        return this.enableDisable(string, enablerDisabler2, "time category", Time.time_category_keys);
    }

    private boolean enableTimeCategories(String string) {
        return this.enableDisableTimeCategories(string, new HakunaConsole.EnablerDisabler(){

            @Override
            public boolean set(SimpleTask simpleTask, String string) {
                return ((Time)simpleTask).enableTimeCategory(string);
            }
        });
    }

    private boolean disableTimeCategories(String string) {
        return this.enableDisableTimeCategories(string, new HakunaConsole.EnablerDisabler(){

            @Override
            public boolean set(SimpleTask simpleTask, String string) {
                return ((Time)simpleTask).disableTimeCategory(string);
            }
        });
    }

    @Override
    protected int getopt(String[] stringArray, int n) {
        int n2 = 1;
        if (stringArray[n].contentEquals("-N") || stringArray[n].contentEquals("--times")) {
            if (n < stringArray.length - 1 && !this.enableTimeCategories(stringArray[n + n2++])) {
                n2 = 0;
            }
        } else if (stringArray[n].startsWith("--times=")) {
            if (!this.enableTimeCategories(stringArray[n].replaceFirst("--times=", ""))) {
                n2 = 0;
            }
        } else if (stringArray[n].contentEquals("--nottimes")) {
            if (n < stringArray.length - 1 && !this.disableTimeCategories(stringArray[n + n2++])) {
                n2 = 0;
            }
        } else if (stringArray[n].startsWith("--nottimes=")) {
            if (!this.disableTimeCategories(stringArray[n].replaceFirst("--nottimes=", ""))) {
                n2 = 0;
            }
        } else {
            n2 = super.getopt(stringArray, n);
        }
        return n2;
    }

    public TimeConsole() {
        super(new Time());
    }
}

