/*
 * Decompiled with CFR 0.152.
 */
package com.bw.hakuna.console;

import com.bw.hakuna.console.HakunaConsole;
import com.bw.swahili.SimpleTask;
import com.bw.swahili.Vocabulary;

public class VocabularyConsole
extends HakunaConsole {
    @Override
    public String versionNr() {
        return "0.03/Java";
    }

    @Override
    public String helpDescription() {
        return "Practice swahili vocabulary.";
    }

    @Override
    public String getTask() {
        if (this.st.getSolution().contentEquals("")) {
            return this.st.getTask();
        }
        return this.st.getTask().replaceAll("##", "\n[").replaceAll("#", "]  [") + "]";
    }

    @Override
    protected void printOptions() {
        super.printOptions();
        this.printOption("", "", "");
        assert (Vocabulary.vocabulary_wordlist_keys.length == 10);
        this.printOption("-L", "--local", "draw all suggestions from one wordlist");
        this.printOption("", "--norepetition", "don't repeat unsolved tasks soon again");
        this.printOption("", "", "(repetition is enabled with statistics)");
        this.printOption("-O", "--other", "task other, solution Swahili");
        this.printOption("-S", "--swahili", "task Swahili, solution other");
        this.printOption("-W", "--words=N[,N]", "enable given wordlists (comma separated list of");
        this.printOption("", "", "wordlists ('" + Vocabulary.vocabulary_wordlist_keys[0] + "', '" + Vocabulary.vocabulary_wordlist_keys[1] + "', '" + Vocabulary.vocabulary_wordlist_keys[2] + "', '" + Vocabulary.vocabulary_wordlist_keys[3] + "', '");
        this.printOption("", "", "'" + Vocabulary.vocabulary_wordlist_keys[4] + "', '" + Vocabulary.vocabulary_wordlist_keys[5] + "', '" + Vocabulary.vocabulary_wordlist_keys[6] + "', '" + Vocabulary.vocabulary_wordlist_keys[7] + "', '" + Vocabulary.vocabulary_wordlist_keys[8] + "', '");
        this.printOption("", "", "'" + Vocabulary.vocabulary_wordlist_keys[9] + "'))");
        this.printOption("", "--notwords=N[,N]", "disable given wordlists");
        this.printOption("", "", "");
    }

    private boolean enableDisableWordlist(String string, HakunaConsole.EnablerDisabler enablerDisabler2) {
        return this.enableDisable(string, enablerDisabler2, "wordlist", Vocabulary.vocabulary_wordlist_keys);
    }

    private boolean enableWordlist(String string) {
        return this.enableDisableWordlist(string, new HakunaConsole.EnablerDisabler(){

            @Override
            public boolean set(SimpleTask simpleTask, String string) {
                return ((Vocabulary)simpleTask).enableWordlist(string);
            }
        });
    }

    private boolean disableWordlist(String string) {
        return this.enableDisableWordlist(string, new HakunaConsole.EnablerDisabler(){

            @Override
            public boolean set(SimpleTask simpleTask, String string) {
                return ((Vocabulary)simpleTask).disableWordlist(string);
            }
        });
    }

    @Override
    protected int getopt(String[] stringArray, int n) {
        int n2 = 1;
        if (stringArray[n].contentEquals("-L") || stringArray[n].contentEquals("--local")) {
            ((Vocabulary)this.st).setLocal(true);
        } else if (stringArray[n].contentEquals("--norepetition")) {
            ((Vocabulary)this.st).setRepetition(false);
        } else if (stringArray[n].contentEquals("-O") || stringArray[n].contentEquals("--other")) {
            ((Vocabulary)this.st).setDirection(1);
        } else if (stringArray[n].contentEquals("-S") || stringArray[n].contentEquals("--swahili")) {
            ((Vocabulary)this.st).setDirection(0);
        } else if (stringArray[n].contentEquals("-W") || stringArray[n].contentEquals("--words")) {
            if (n < stringArray.length - 1 && !this.enableWordlist(stringArray[n + n2++])) {
                n2 = 0;
            }
        } else if (stringArray[n].startsWith("--words=")) {
            if (!this.enableWordlist(stringArray[n].replaceFirst("--words=", ""))) {
                n2 = 0;
            }
        } else if (stringArray[n].contentEquals("--notwords")) {
            if (n < stringArray.length - 1 && !this.disableWordlist(stringArray[n + n2++])) {
                n2 = 0;
            }
        } else if (stringArray[n].startsWith("--notwords=")) {
            if (!this.disableWordlist(stringArray[n].replaceFirst("--notwords=", ""))) {
                n2 = 0;
            }
        } else {
            n2 = super.getopt(stringArray, n);
        }
        return n2;
    }

    public VocabularyConsole() {
        super(new Vocabulary());
    }
}

