/*
 * Decompiled with CFR 0.152.
 */
package com.bw.swahili;

import com.bw.swahili.SimpleTask;

public class Lokativ
extends SimpleTask {
    public static final String[] classes = new String[]{"ni", "u", "yu", "tu", "m", "wa", "ki", "vi", "i", "zi", "li", "ya", "u", "i", "u", "zi"};
    private static final int classesz = classes.length;
    private String[] classnames;
    private static final String[] classnames_de = new String[]{"ich", "du", "er/sie/es", "wir", "ihr", "sie", "ki/vi Sn.", "ki/vi Pl.", "N Sn.", "N Pl.", "-/ma Sn.", "-/ma Pl.", "m/mi Sn.", "m/mi Pl.", "U Sn.", "U Pl."};
    private static final String[] classnames_en = new String[]{"I", "you sn.", "he/she/it", "we", "you pl.", "they", "ki/vi sn.", "ki/vi pl.", "N sn.", "N pl.", "-/ma sn.", "-/ma pl.", "m/mi sn.", "m/mi pl.", "U sn.", "U pl."};
    public static final String[] classescheat = new String[]{"ni", "ni", "u", "u", "a", "yu", "tu", "tu", "m", "m", "wa", "wa", "ki/vi", "ki/vi", "N", "i/zi", "-/ma", "li/ya", "m/mi", "u/i", "U", "u/zi"};
    public static final int classescheatsz = classescheat.length;
    public static final String[][] class_examples = new String[][]{{"mimi"}, {"wewe"}, {"yeye", "dereva", "Lisa", "Asali", "mgeni", "mtoto"}, {"sisi", "Mimi na Asali"}, {"nyinyi", "wewe na Lisa"}, {"wao", "Lisa na Asali", "wageni", "watoto"}, {"kitabu", "kibanda cha simu", "kitu"}, {"vitabu", "vibanda cha simu", "vitu"}, {"ndizi", "peni"}, {"ndizi kumi", "peni kumi"}, {"embe", "gazeti", "gauni"}, {"maembe", "magazeti", "magauni"}, {"mkate", "mchezo", "Mlango"}, {"mikate", "michezo", "milango"}, {"uma", "ukurasa"}, {"nyuma", "kurasa"}};
    private String[][] class_example_translations;
    public static final String[][] class_example_translations_de = new String[][]{{"ich"}, {"du"}, {"er/sie/es", "der Fahrer", "Lisa", "Asali", "der Gast", "das Kind"}, {"wir", "ich und Asali"}, {"ihr", "du und Lisa"}, {"sie", "Lisa und Asali", "die G\u00e4ste", "die Kinder"}, {"das Buch", "die Telefonzelle", "das Ding"}, {"die B\u00fccher", "die Telefonzellen", "die Dinge"}, {"die Banane", "der Kugelschreiber"}, {"zehn Bananen", "zehn Kugelschreiber"}, {"die Mango", "die Zeitung", "das Kleid"}, {"die Mangos", "die Zeitungen", "die Kleider"}, {"das Brot", "das Spiel", "die T\u00fcr"}, {"die Brote", "die Spiele", "die T\u00fcren"}, {"die Gabel", "die Buchseite"}, {"die Gabeln", "die Buchseiten"}};
    public static final String[][] class_example_translations_en = new String[][]{{"I"}, {"you"}, {"he/she/it", "the driver", "Lisa", "Asali", "the guest", "the child"}, {"we", "me and Asali"}, {"you", "you and Lisa"}, {"sie", "Lisa and Asali", "the guests", "the children"}, {"the book", "the phone booth", "the thing"}, {"the books", "the phone booths", "the things"}, {"the banana", "the pen"}, {"ten bananas", "ten pens"}, {"the mango", "the newspaper", "the gown"}, {"the mangos", "the newspapers", "the gowns"}, {"the bread", "the game", "the door"}, {"the breads", "the games", "the doors"}, {"the fork", "the page"}, {"the forks", "the pages"}};
    public static final String[] locations = new String[]{"ko", "po", "mo"};
    private static final int locationsz = locations.length;
    private String[] locationnames;
    private static final String[] locationnames_de = new String[]{"unbestimmter Ort", "bestimmter Ort beim Sprecher", "in geschlossenem Raum"};
    private static final String[] locationnames_en = new String[]{"unspecific place", "specific place near speaker", "in closed room"};
    public static final String[][] lokativ_situations = new String[][]{{"wapi?", "mjini."}, {"hapa hapa.", "mbele ya basi."}, {"chumbani.", "nyumbani."}};
    private String[][] lokativ_situation_translations;
    public static final String[][] lokativ_situation_translations_de = new String[][]{{"wo", "in der Stadt"}, {"hier", "vor dem Bus"}, {"im Zimmer", "im Haus"}};
    public static final String[][] lokativ_situation_translations_en = new String[][]{{"where", "in the city"}, {"right here", "in front of the bus"}, {"in the room", "in the house"}};
    public static final String[] tempi = new String[]{"na", "ta"};
    private static final int tempisz = tempi.length;
    private String[] tempusnames;
    private static final String[] tempusnames_de = new String[]{"Pr\u00e4sens", "Zukunft"};
    private static final String[] tempusnames_en = new String[]{"present", "future"};
    public static final String[] class_keys = new String[]{"mwa_ni", "mwa_u", "mwa_a", "mwa_tu", "mwa_m", "mwa_wa", "kivi_sn", "kivi_pl", "N_sn", "N_pl", "jima_sn", "jima_pl", "mmi_sn", "mmi_pl", "U_sn", "U_pl"};
    private boolean[] classes_enabled = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    public static final String[] location_keys = new String[]{"ko", "po", "mo"};
    private boolean[] locations_enabled = new boolean[]{true, true, true};
    public static final String[] tempus_keys = tempi;
    private boolean[] tempi_enabled = new boolean[]{true, true};

    public String[] getSubjectNames() {
        return this.classnames;
    }

    public String[] getLokativNames() {
        return this.locationnames;
    }

    public String[] getTempusNames() {
        return this.tempusnames;
    }

    public boolean enableClass(String string) {
        return this.enableDisable(this.classes_enabled, class_keys, string, true);
    }

    public boolean disableClass(String string) {
        return this.enableDisable(this.classes_enabled, class_keys, string, false);
    }

    public int getEnabledClasses() {
        return this.getEnabled(this.classes_enabled);
    }

    public boolean enableLocation(String string) {
        return this.enableDisable(this.locations_enabled, location_keys, string, true);
    }

    public boolean disableLocation(String string) {
        return this.enableDisable(this.locations_enabled, location_keys, string, false);
    }

    public int getEnabledLokativs() {
        return this.getEnabled(this.locations_enabled);
    }

    public boolean enableTempus(String string) {
        return this.enableDisable(this.tempi_enabled, tempus_keys, string, true);
    }

    public boolean disableTempus(String string) {
        return this.enableDisable(this.tempi_enabled, tempus_keys, string, false);
    }

    public int getEnabledTempi() {
        return this.getEnabled(this.tempi_enabled);
    }

    public void mk_task(int n, int n2, int n3, int n4, int n5, TaskSolutionInfo taskSolutionInfo) {
        String string;
        String string2;
        String string3 = class_examples[n][n2];
        String string4 = this.classnames[n];
        String string5 = lokativ_situations[n3][n4];
        String string6 = this.locationnames[n3];
        if (n5 == 0) {
            string2 = "Sasa " + string3 + " [-] " + string5;
            string = "Sasa " + string3 + " " + classes[n] + locations[n3] + " " + string5;
        } else {
            string2 = "Kesho " + string3 + " [-] " + string5;
            string = "Kesho " + string3 + " " + classes[n] + "takuwa " + string5;
        }
        taskSolutionInfo.assign(string2, string, this.class_example_translations[n][n2] + " (" + string4 + "), " + this.lokativ_situation_translations[n3][n4] + " (" + string6 + "), " + this.tempusnames[n5], n, n3, n5);
    }

    @Override
    public void shuffle() {
        int n = this.getEnabledClasses();
        int n2 = this.getEnabledLokativs();
        int n3 = this.getEnabledTempi();
        if (n == 0 || n2 == 0 || n3 == 0) {
            ((TaskSolutionInfo)this.tsi).assign(" - " + (n == 0 ? "no class" : "") + (n == 0 && n2 + n3 <= 1 ? " and " : "") + (n2 == 0 ? "no location" : "") + (n3 == 0 && n + n2 <= 1 ? " and " : "") + (n3 == 0 ? "no tempus" : "") + " enabled, no task" + " - ", "", "", -1, -1, -1);
            return;
        }
        if (this.preshuffle()) {
            return;
        }
        int n4 = this.nextInt(n, this.classes_enabled);
        int n5 = this.nextInt(n2, this.locations_enabled);
        int n6 = !this.tempi_enabled[0] || this.tempi_enabled[1] && this.nextInt(4) == 0 ? 1 : 0;
        this.mk_task(n4, this.nextInt(class_examples[n4].length), n5, this.nextInt(lokativ_situations[n5].length), n6, (TaskSolutionInfo)this.tsi);
    }

    private void updateTable(int[][] nArray) {
        int n = ((TaskSolutionInfo)this.tsi).classN;
        int n2 = ((TaskSolutionInfo)this.tsi).locationN;
        int n3 = ((TaskSolutionInfo)this.tsi).tempusN;
        assert (n >= 0 && n2 >= 0 && n3 >= 0 || n < 0 && n2 < 0 && n3 < 0);
        if (n >= 0 && n2 >= 0 && n3 >= 0) {
            int[] nArray2 = nArray[n3 == 0 ? n2 : locations.length];
            int n4 = n;
            nArray2[n4] = nArray2[n4] + 1;
        }
    }

    @Override
    public void right() {
        super.right();
        this.updateTable(this.righttable);
    }

    @Override
    public void wrong() {
        super.wrong();
        this.updateTable(this.wrongtable);
    }

    public void dump() {
        TaskSolutionInfo taskSolutionInfo = new TaskSolutionInfo();
        for (int i = 0; i < tempisz; ++i) {
            for (int j = 0; j < classesz; ++j) {
                if (!this.classes_enabled[j]) continue;
                for (int k = 0; k < class_examples[j].length; ++k) {
                    for (int i2 = 0; i2 < locationsz; ++i2) {
                        if (!this.locations_enabled[i2]) continue;
                        for (int i3 = 0; i3 < lokativ_situations[i2].length; ++i3) {
                            this.mk_task(j, k, i2, i3, i, taskSolutionInfo);
                            System.out.printf("%s\n", taskSolutionInfo.task);
                            System.out.printf("%s\n", taskSolutionInfo.solution);
                            System.out.printf("%s\n\n", taskSolutionInfo.info);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void localize(String string) {
        if (string.contentEquals("de")) {
            this.classnames = classnames_de;
            this.class_example_translations = class_example_translations_de;
            this.locationnames = locationnames_de;
            this.lokativ_situation_translations = lokativ_situation_translations_de;
            this.tempusnames = tempusnames_de;
        } else {
            this.classnames = classnames_en;
            this.class_example_translations = class_example_translations_en;
            this.locationnames = locationnames_en;
            this.lokativ_situation_translations = lokativ_situation_translations_en;
            this.tempusnames = tempusnames_en;
        }
        assert (this.classnames.length == classesz);
        assert (this.flat_length(this.class_example_translations) == this.flat_length(class_examples));
        assert (this.locationnames.length == locationsz);
        assert (this.flat_length(this.lokativ_situation_translations) == this.flat_length(lokativ_situations));
    }

    public Lokativ() {
        super(classes, new String[]{locations[0], locations[1], locations[2], "ta"});
        this.tsi = new TaskSolutionInfo();
        assert (class_keys.length == this.classes_enabled.length);
        assert (location_keys.length == this.locations_enabled.length);
        assert (tempus_keys.length == this.tempi_enabled.length);
    }

    class TaskSolutionInfo
    extends SimpleTask.TaskSolutionInfo {
        public int classN = -1;
        public int locationN = -1;
        public int tempusN = -1;

        public void assign(String string, String string2, String string3, int n, int n2, int n3) {
            super.assign(string, string2, string3);
            this.classN = n;
            this.locationN = n2;
            this.tempusN = n3;
        }

        @Override
        public boolean contentEquals(SimpleTask.TaskSolutionInfo taskSolutionInfo) {
            return super.contentEquals(taskSolutionInfo) && this.classN == ((TaskSolutionInfo)taskSolutionInfo).classN && this.locationN == ((TaskSolutionInfo)taskSolutionInfo).locationN && this.tempusN == ((TaskSolutionInfo)taskSolutionInfo).tempusN;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public TaskSolutionInfo() {
            this.classN = -1;
            this.locationN = -1;
            this.tempusN = -1;
        }

        public TaskSolutionInfo(String string, String string2, String string3, int n, int n2, int n3) {
            this.assign(string, string2, string3, n, n2, n3);
        }
    }
}

