/*
 * Decompiled with CFR 0.152.
 */
package com.bw.swahili;

import com.bw.swahili.Statistics;
import java.util.Locale;
import java.util.Random;
import java.util.Vector;

public abstract class SimpleTask
extends Statistics {
    private boolean repetition = true;
    protected TaskSolutionInfo tsi = null;
    private Vector<TaskSolutionInfo> badbucket = new Vector();
    private Vector<TaskSolutionInfo> badbadbucket = new Vector();
    private Vector<TaskSolutionInfo> bucket = null;
    private TaskSolutionInfo bucketpick = null;
    public final int preshuffle_base_threshold = 5;
    protected Random rnd = new Random();

    public void clearRepetitionBuckets() {
        this.badbucket.clear();
        this.badbadbucket.clear();
    }

    public void setRepetition(boolean bl) {
        if (this.repetition && !bl) {
            this.clearRepetitionBuckets();
        }
        this.repetition = bl;
    }

    protected boolean keysUniqueAndSizeOfEnabled(String[] stringArray, boolean[] blArray) {
        if (stringArray.length != blArray.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (!stringArray[i].contentEquals(stringArray[j])) continue;
                return false;
            }
        }
        return true;
    }

    protected int flat_length(String[][] stringArray) {
        int n = 0;
        String[][] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            String[] stringArray3;
            for (String string : stringArray3 = stringArray2[i]) {
                ++n;
            }
        }
        return n;
    }

    protected boolean enableDisable(boolean[] blArray, String[] stringArray, String string, boolean bl) {
        assert (blArray.length == stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.contentEquals(stringArray[i])) continue;
            if (blArray[i] && !bl) {
                this.clearRepetitionBuckets();
            }
            blArray[i] = bl;
            return true;
        }
        return false;
    }

    protected int getEnabled(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    public String getTask() {
        assert (this.tsi != null);
        return this.tsi.task;
    }

    public String getSolution() {
        assert (this.tsi != null);
        return this.tsi.solution;
    }

    public String getInfo() {
        assert (this.tsi != null);
        return this.tsi.info;
    }

    protected boolean preshuffle() {
        int n = this.badbucket.size() + this.badbadbucket.size();
        int n2 = Math.max(1, 5 - n);
        if (this.repetition && this.nextInt(n2 + n) >= n2) {
            if (this.badbucket.size() == 0) {
                this.bucket = this.badbadbucket;
            } else if (this.badbadbucket.size() == 0) {
                this.bucket = this.badbucket;
            } else {
                Vector<TaskSolutionInfo> vector = this.bucket = this.nextInt(2) == 0 ? this.badbucket : this.badbadbucket;
            }
            assert (this.bucket.size() > 0);
            this.bucketpick = this.bucket.get(this.nextInt(this.bucket.size()));
            this.tsi.assign(this.bucketpick);
            return true;
        }
        this.bucket = null;
        this.bucketpick = null;
        return false;
    }

    private void check_for_recreation(Vector<TaskSolutionInfo> vector) {
        if (this.bucket != null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.get(i).contentEquals(this.tsi)) continue;
            this.bucket = vector;
            this.bucketpick = vector.get(i);
            return;
        }
    }

    private void check_for_recreation() {
        this.check_for_recreation(this.badbadbucket);
        this.check_for_recreation(this.badbucket);
    }

    @Override
    public void right() {
        super.right();
        if (!this.repetition) {
            return;
        }
        this.check_for_recreation();
        if (this.bucketpick != null) {
            if (this.bucket == this.badbucket) {
                assert (this.bucketpick != null);
                this.badbucket.remove(this.bucketpick);
            } else {
                assert (this.bucketpick != null);
                assert (this.bucket == this.badbadbucket);
                this.badbadbucket.remove(this.bucketpick);
                this.badbucket.add(this.bucketpick);
            }
        }
    }

    @Override
    public void wrong() {
        super.wrong();
        if (!this.repetition) {
            return;
        }
        this.check_for_recreation();
        if (this.bucket == null) {
            assert (this.bucketpick == null);
            try {
                this.badbadbucket.add((TaskSolutionInfo)this.tsi.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                assert (false);
            }
        } else if (this.bucket == this.badbucket) {
            this.badbucket.remove(this.bucketpick);
            this.badbadbucket.add(this.bucketpick);
        }
    }

    public abstract void shuffle();

    int nextInt(int n) {
        return this.rnd.nextInt(n);
    }

    protected int nextInt(int n, boolean[] blArray) {
        int n2 = this.rnd.nextInt(n);
        int n3 = -1;
        int n4 = 0;
        while (n2 >= 0) {
            ++n3;
            if (blArray[n4]) {
                --n2;
            }
            ++n4;
        }
        assert (n3 >= 0);
        assert (n3 < blArray.length);
        return n3;
    }

    protected abstract void localize(String var1);

    public SimpleTask(String[] stringArray, String[] stringArray2) {
        super(stringArray, stringArray2);
        this.localize(Locale.getDefault().getLanguage());
    }

    class TaskSolutionInfo
    implements Cloneable {
        public String task = null;
        public String solution = null;
        public String info = null;

        public boolean contentEquals(TaskSolutionInfo taskSolutionInfo) {
            return this.task.contentEquals(taskSolutionInfo.task) && this.solution.contentEquals(taskSolutionInfo.solution) && this.info.contentEquals(taskSolutionInfo.info);
        }

        public void assign(String string, String string2, String string3) {
            this.task = string;
            this.solution = string2;
            this.info = string3;
        }

        public void assign(TaskSolutionInfo taskSolutionInfo) {
            this.assign(taskSolutionInfo.task, taskSolutionInfo.solution, taskSolutionInfo.info);
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public TaskSolutionInfo() {
            this.assign(" - not shuffled yet - ", "", "");
        }

        public TaskSolutionInfo(String string, String string2, String string3) {
            this.assign(string, string2, string3);
        }
    }
}

